rm(list=objects())
setwd("~/Desktop/Experiments/Simulations/Results")

type <- 2
path <- "Sparse"
K <- 3
M <- 100 # number of experiments############a
N <- 500
rho_list <- exp(seq(log(1), log(0.05), length.out = 15))

# record the errors
Error_missSBM <- matrix(NA, ncol = 3, nrow = 15)
Error_Var <- matrix(NA, ncol = 3, nrow = 15)
Error_true_Z <- matrix(NA, ncol = 3, nrow = 15)
Error_softImpute <- matrix(NA, ncol = 3, nrow = 15)
Error_av <- matrix(NA, ncol = 3, nrow = 15)

for (n in 1:15){
  res <- readRDS(paste0(path, "/r_", n,".RDS"))
  rho <- rho_list[n]
  Error_missSBM[n,] <- quantile(res$Error_missSBM/rho**2, probs = c(0.25, 0.5, 0.75))
  
  Error_Var[n,] <- quantile(res$Error_Var/rho**2, probs = c(0.25, 0.5, 0.75))
  
  Error_softImpute[n,] <- quantile(res$Error_softImpute/rho**2, probs = c(0.25, 0.5, 0.75))
  
  Error_true_Z[n,] <- quantile(res$Error_true_Z/rho**2, probs = c(0.25, 0.5, 0.75))
  
  Error_true_Z[n,] <- quantile(res$Error_true_Z/rho**2, probs = c(0.25, 0.5, 0.75))
  
  Error_av[n,] <- quantile(res$Error_av/rho**2, probs = c(0.25, 0.5, 0.75))
}

#Error_softImpute <- log(Error_softImpute)
#Error_true_Z <- log(Error_true_Z)
#Error_Var <- log(Error_Var)
#Error_missSBM <- log(Error_missSBM)

plot(x = rho_list, y = Error_softImpute[,2], type = 'l', col = 'green',
     xlab = expression(paste("Sparsity ", rho)), ylab = "Error", log = "x", ylim = c(0, 0.4))
lines(x = rho_list, y = Error_softImpute[,1], lty = 3, col = 'green')
lines(x = rho_list, y = Error_softImpute[,3], lty = 3, col = 'green')

lines(x = rho_list, y = Error_true_Z[,2], col = 'black')
lines(x = rho_list, y = Error_true_Z[,1], lty = 3, col = 'black')
lines(x = rho_list, y = Error_true_Z[,3], lty = 3, col = 'black')

lines(x = rho_list, y = Error_Var[,2], col = 'blue')
lines(x = rho_list, y = Error_Var[,1], lty = 3, col = 'blue')
lines(x = rho_list, y = Error_Var[,3], lty = 3, col = 'blue')

lines(x = rho_list, y = Error_missSBM[,2], col = 'red')
lines(x = rho_list, y = Error_missSBM[,1], lty = 3, col = 'red')
lines(x = rho_list, y = Error_missSBM[,3], lty = 3, col = 'red')

lines(x = rho_list, y = Error_av[,2], col = 'orange')
lines(x = rho_list, y = Error_av[,1], lty = 3, col = 'orange')
lines(x = rho_list, y = Error_av[,3], lty = 3, col = 'orange')



